PYTHON="/opt/conda/bin/python"
RESULTS_DIR_0="df_his6000_new1500_50"
RESULTS_DIR_1="df_his6000_new1900_50"
RESULTS_DIR_2="df_his6000_new2300_50"
RESULTS_DIR_3="df_his6000_new2700_50"
file_NAME="6000_all_0.9_compare.csv"
mkdir -p $RESULTS_DIR_0 
mkdir -p $RESULTS_DIR_1
mkdir -p $RESULTS_DIR_2
mkdir -p $RESULTS_DIR_3


# Run the loop 50 times.
for i in {1..50}
do
    echo "Running iteration $i..."
    # Run the Python script and directly redirect the output to the target file
    $PYTHON exp_multiCPU.py --seed $i --T 1500 --bid_num 50 --file_name $file_NAME --num_processes 32 > "$RESULTS_DIR_0/output_results_${i}_.txt" 
    $PYTHON exp_multiCPU.py --seed $i --T 1900 --bid_num 50 --file_name $file_NAME --num_processes 32 > "$RESULTS_DIR_1/output_results_${i}.txt" 
    $PYTHON exp_multiCPU.py --seed $i --T 2300 --bid_num 50 --file_name $file_NAME --num_processes 32 > "$RESULTS_DIR_2/output_results_${i}.txt" 
    $PYTHON exp_multiCPU.py --seed $i --T 2700 --bid_num 50 --file_name $file_NAME --num_processes 32 > "$RESULTS_DIR_3/output_results_${i}.txt" 
    
    # Check if the operation was successful
    if [ $? -eq 0 ]; then
        echo "Iteration $i completed successfully"
    else
        echo "Error in iteration $i"
    fi
done

echo "All iterations completed!"